import pandas as pd
import pickle
from decision_company import read_csv_file, sum_up, is_null, n_unique, create_dataframe


atp_tennis = read_csv_file('atp_tennis.csv')

# Data Quality Report
missing_values = sum_up(is_null(atp_tennis))
unique_values = n_unique(atp_tennis, ['Tournament', 'Series', 'Court', 'Surface', 'Round'])

data_quality_report = create_dataframe({'Missing Values': missing_values, 'Unique Values': unique_values})

print(data_quality_report)
pickle.dump(data_quality_report,open("./ref_result/data_quality_report.pkl","wb"))